%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 							  %
% written by Gertjan van Noord				  %
% (C) 1988 - 1994	                                  %
% 							  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- unknown(_,fail).

% load this one first; some of the lib's add things once they
% know that library(command) is loaded

:- ensure_loaded(cmd).

:- use_module([
% don't leave home without it:
               library(link_clause),
               library(term_expand),
	       library(flags),
% packages that are assumed to be available:
% these will be calling each-other anyway..
		library(feature),
	       library(show),
	       library(p_tree),
	       library(latex)
	      ]).

:- initialize_flag(ask,off).               
	% asks confirmation for each command
:- initialize_flag(object_saving,semi).   
        % after each parse save result in database
        % but throw them away upon new parse/generation cmd.
:- initialize_flag(top_features,undefined).
        % variable top category for parsing and generation
:- initialize_flag(parser_mode,[]).       
        % initialization: no parsers defined 
:- initialize_flag(generator_mode,[]).    
        % initialization: no generators defined
:- initialize_flag(off(parser_mode),[]).    
        % no parser is disabled
:- initialize_flag(off(generator_mode),[]). 
        % no generator is disabled
:- initialize_flag(current_no,1).
:- initialize_flag(window,off).

:- version('TkHdrug, version 1.0, june 14 1994').

header :- 
        version,
        write('type r. for command interpreter'),nl,
        write('type x. for X-based command interface (using Tk/Tcl)'),nl.

extern_phon(L,L).

:- ensure_loaded(st_tex),
   ensure_loaded(st_tk),
   ensure_loaded(go),
   ensure_loaded(interpreters),
   ensure_loaded(tk),
   header.


