;;;;
;;;; Reverse-Polish pocket Calculator
;;;
;;; 30 Sep 92
;;;
(setq history '())
(defun audit (item)
	(setq history (cons item history))
	item)

(defun trail ()
	(print history))
;;;
;;;
(setq variables '())

(defun set-var (varname val)
	(cond 
		((member varname variables) t)
		(t (setq variables (cons varname variables))))
	(if (symbolp varname) (set varname val) (print "Whoops!")))

(defun print-vars (vlist)
	(dolist (bvar vlist)
		(princ* bvar " = " (eval bvar) CR)))
;;;

(setq stack '())
(defun top () (car stack))
(defun push (item) (setq stack (cons item stack)))
(defun pop () 
	(cond
		((null stack) nil)
		((null (cdr stack)) (car stack))
		(t (setq ret (car stack)) 
			(setq stack (cdr stack)) 
			ret ) ) )

(defun stack-nth (n)
	(nth n stack) )

(defun exchange () 
	(setq tmp1 (pop)) 
	(setq tmp2 (pop))
	(push tmp1)
	(push tmp2) )

(defun myprint (item)
	(print item)
	(terpri)
	item )

(setq prompt "? ")
(setq commands '())

(defmacro new-command (label help-text &rest body)
	(setq commands (cons label commands))
	(put label 'help help-text)
	`(put ',label 'body '(lambda () ,@body)))

(new-command x 
	"eXchange the top two stack elements."
	(exchange))

(new-command help
	"Prints this help text."
	(dolist (tmp commands)	
			(princ* "\t" tmp "\t" (get tmp 'help) "\n")))

(new-command t "print audit Trail." (trail))
(new-command p "Pop the stack." (pop))
(new-command s "Store to variable." 
	(set-var (stack-nth 0) (stack-nth 1))
	(pop) (pop))
(new-command r "Recall variable value." (push (eval (pop))))
(new-command n "Push the nth stack item." (push (stack-nth (pop))))
(new-command e "Push the top stack item."  (push (top)))
(new-command q "Quit."  
	(princ "Really Quit (y/n) ? ") 
	(cond ((equal (read) 'y)
		(setq calc-finished t))))
(new-command c "clear stack" 	(setq stack nil))
(new-command clear "clear all" 	(setq stack nil)
		(setq variables nil))

(new-command + "sum the two top stack items" (push (+ (pop) (pop))))
(new-command - 
	"difference the two top stack items" 
	(exchange)(push (- (pop) (pop))))

(new-command * "multiply" (push (* (pop) (pop))))
(new-command / "divide" (exchange)(push (/ (pop) (pop))))
(new-command % "remainder" (push (rem (pop) (pop))))

(defun calc ()
	(print "Type help for instructions")
	(terpri)
	(princ prompt)
	(setq input t)
	(setq calc-finished nil)
	(do-until (calc-finished)
		(setq input (audit (read)))
		(cond
			((numberp input) (push input))
			((member input commands)  (funcall (get input 'body)))
			((eq input 'cdr) (push (cdr (pop))))
			(t (push input)))
		(print-vars variables)
		(myprint stack)
		(princ prompt) ) )
