	(GraphOpen VGA 2) ; Has to be here because 'new calls button.
	(progn
		; Draw a border around the screen
		(line 10 10 6390 10)
		(line 10 10 10 4800)
		(line 10 4800 6390 4800)
		(line 6390 10 6390 4800))

(setq button textxy)
;
; Elementary O O functions.
;
; Utility function to call a method without arguments. 
(defun selfx (method)
   ((slot this method) this) )

; definition of the class of graphics objects
; Abstract Data Type
(put 'object '*down* '(lambda () ))

; Define the dollar #! quote syntax to get slots from 'this
; #!r => (slot this 'r)
(df quser1 (slotname) (slot this slotname))

; Handy function to set the value of a slot.
(defun setslot (slotname value)
	(put this slotname value))

(defun defclass (_child _parent) (put _child 'class _parent))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; definition of the class - buttons
(setq menuheight (-  4800 17))
(defclass 'button 'obj)    ; buttons are objects
(put 'button 'children nil) ; no instances yet

; simplification of initialization
(put 'button 'new '(lambda (this label function) 
	(setslot 'h 
		(cond 
			((get 'button 'children)
				(+      (get (car(get 'button 'children)) 'h)
						(get (car(get 'button 'children)) 'wi)
						100 ) )
			(t 100) ) )

   (setslot 'v menuheight)
   (setslot 'label label)
   (setslot 'class 'button)
   (setslot 'function function)
	; add it to the list of these objects
	(put 'button 'children 
		(cons this (get 'button 'children)) )
	(selfx 'draw)  ))

(put 'button 'draw '(lambda (this) 
; button draw method
      ((lambda (ret) 
	 ; now save its dimensions
	 (setslot 'wi (car ret))   ; width
	 (setslot 'he (cdr ret))) ; height down
      
      ; first display the button
      ; NB buttons are drawn down from the point, so height 'h is
      ; highest point.
		(button #!h #!v #!label) ) ))

; button mouse up functions
(defun hitp (mx my x1 y1 x2 y2)
   (and (> mx x1) 
      (< mx x2) 
      (> my y1) 
      (< my y2) ) )

(defun draw-polyline (p)
	(do-while (cdr p)
		(line (caar p) (cdar p) (caadr p) (cdadr p))
		(setq p (cdr p)) ) )

(defun invbutton (this)
      
	(draw-polyline (list
		(cons   #!h #!v)
		(cons   (+  #!h #!wi) #!v)
		(cons   (+  #!h #!wi) (-  #!v #!he))
		(cons   #!h (-  #!v #!he))
		(cons   #!h #!v ) )) )

(put 'button '*up* '(lambda (this mh mv)
      (cond
	 ; check if the button has been hit
		 ((hitp mh mv  #!h  (-  #!v #!he)  (+  #!h #!wi) #!v)
			; Yes, so highlight button
			(invbutton this)
	    	; then execute the button function
	    	(selfx 'function)
			(invbutton this)
			t )
	 (t nil) ) ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'quit 'button)
((slot 'quit 'new) 'quit "Quit" 
   '(lambda (this) (setq quitflag nil)) )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'clear 'button)
((slot 'clear 'new) 'clear "Clear"
   '(lambda (this)  (clear) (invbutton this) (drawl)) )

(defclass 'edit 'button)
((slot 'edit 'new) 'edit "Edit" 
   '(lambda (this) (GraphClose)(system "viz.exe" "gob.lsp")
	   (load "gob.lsp")(drawl)) )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cadddr (x)
   (car (cdr (cdr (cdr x)))) )

(defun evprint (this)
   (princ "Type any key to quit\n")
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (princ ev) 
      (princ CR) )
    (clear)
	(invbutton this)
	(drawl) )

(defclass 'evprint 'button)
((slot 'evprint 'new) 'evprint "Trace" evprint)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun evfollow (this)
   (setq c 0)
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (cond 
		 ((equal (car ev) *move*)
	    (colour (setq c
	       (rem (+ c 1) 16)))
	    (button (caddr ev) (cadddr ev) "."))
	 (t nil) )  ) )

(defclass 'evfollow 'button)
((slot 'evfollow 'new) 'evfollow "Move" evfollow)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun evrubber (this)
      (setq posx 0)(setq posy 0)
	    (setq lastx 0)
	    (setq lasty 0)
   (mode XOR)    ; XOR mode
    (line lastx lasty posx posy)   ; initialise 
   (do-while (not (equal (car (setq ev (getevent))) *keys*))
      (cond 
		 ((equal (car ev) *move*)
	    (line lastx lasty posx posy)    ; undraw the last existing line
			(setq posx (caddr ev))          ; get the new positi 
	    (setq posy (cadddr ev))
	    (line  lastx lasty posx posy))  ; draw the new line
		 ((equal (car ev) *up*)
			(setq polyline (cons (cons posx posy) polyline ))
	    (setq lastx posx )              ; save the new coodinates
	    (setq lasty posy ) )
	 (t nil) )  ) )

; Rubber band line drawing
(defclass 'evrubber 'button)
((slot 'evrubber 'new) 'evrubber "Drawing" evrubber)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; filling areas
(defun evfill (this)
	(fillstyle 5 3)
	(fillarea
		'(      (2000.4 . 1500.6)
			(2500 . 2000)
			(2000 . 2500)
			(1500 . 2000)
			(2000 . 1500) ) ) )

(defclass 'evfill 'button)
((slot 'evfill 'new) 'evfill "Filling" evfill)
;;;;;;;;;;;;
(defun drawl ()
    (distribute 'draw (get 'button 'children)) )

(defun distribute (method obs)
   (do-while obs
		 ((slot (car obs) method) (car obs))
		  (setq obs (cdr obs)) ) )

(defun gob (tree)
   (setq quitflag t)
	 (do-while quitflag
      (setq ev (getevent))
      (cond 
		 ((equal (car ev) *up*)
	    (setq tmp tree)
			(do-while tmp
	    (cond 
			   ; call the *up* function for the object,
	       ; if it returns true, then stop the loop
	       ; by setting tmp to nil
				  (( (slot (car tmp) '*up*) ; function to call
		     (car tmp) (caddr ev) (cadddr ev)) ; args
		   
		  (setq tmp nil)) ; executed if above not nil
	       
	       (t (setq tmp (cdr tmp))) ))); otherwise try the next
	 (t nil) )  ) )

(defun r ()
	(setq polyline '())
	(mode XOR)
	(gob (get 'button 'children))
	(GraphClose) )
(r)
