#define NIL (&real_nil)

#define PAIR 0
#define IDENTIFYER 1
#define INTEGER 2
#define SUBRP 3
#define FSUBRP 4
#define STRING 5
#define FILEPTR 6
#define FLOAT 7
#define BIGSTRING 8
#define NULL_OBJ 9
#define VOIDPTR 10
#define CONSTANT 11

#define LEN_STRING 8
#define POOL_SIZE 3000
#define HASHMODULO 257

/* #define FILESUFFIX ".lsp"    */

typedef struct cell {
   int zcount ;
   char ztype ; /* Permitted values:
				  * NULL_OBJ, PAIR , IDENTIFYER, INTEGER, STRING, SUBRP, FSUBRP,
		  * FILEPTR, FLOAT, BIGSTRING
                  */
   union {
   		int zinteger;			/* INTEGER */
		float zfloat;					/* FLOAT */
   		char zstring[LEN_STRING];		/* STRING */
   		struct cell *(*zfunction)();	/* SUBRP or FSUBRP */
		FILE *zfile;					/* FILEPTR */
                void *zvoid;			/* VOIDPTR */
		struct {					/* PAIR */
			struct cell *zcar;	/* also apval in symbols */
   			struct cell *zcdr;	/* also props in symbols 
						 		* and BIGSTRING continuation
						 		*/
		} zpair;
	} reg;
		
} CELL;

#define zprops(symbol) (symbol->reg.zpair.zcdr)
#define zapval(symbol) (symbol->reg.zpair.zcar)

typedef CELL *EXP;	/* pointer to a cell */
typedef EXP FCELLPTR();	/* function returning pointer to a cell */
typedef FCELLPTR *PTRFCELLPTR; /* pointer to a function returning a
				pointer to a cell */

#define WEIRDCHAR '|'
#define USERCHAR1 '!'
#define USERCHAR2 '?'
#define BQUOTECHAR '`'
#define QUOTECHAR '\''
#define COMMACHAR ','
#define FUNCCHAR '#'
#define ATCHAR '@'

extern int flag_non_standard;
extern CELL real_nil;
extern EXP T;
extern EXP PRINTNAME;
extern EXP beof;
extern EXP lpar;
extern EXP rpar;
extern EXP quote;
extern EXP raw_quote;
extern EXP back_quote;
extern EXP backquote;
extern EXP raw_func;
extern EXP func_quote;
extern EXP comma;
extern EXP raw_comma;
extern EXP comma_at;
extern EXP raw_comma_at;
extern EXP uchar1;
extern EXP raw_uchar1;
extern EXP uchar2;
extern EXP raw_uchar2;
extern EXP period;
extern EXP free_list;
extern EXP UNBOUND;

extern int trace_on; /* Flag set when tracing */
extern void trace_exp_aux(EXP);
extern void traceaux(char *);
extern void c_error(char *, EXP);
extern EXP c_error_func(char *, EXP);
extern void serr(char *);
extern void fatal_err(char *);

extern EXP eq(EXP, EXP);
extern EXP equal(EXP, EXP);
extern EXP member();
extern EXP nth(int, EXP);
/*
extern EXP idp();
extern EXP atom();
extern EXP stringp();      
extern EXP bigstringp();
extern EXP numberp();
extern EXP floatp();
extern EXP fsubrp();
extern EXP subrp();
extern EXP filep();
*/
extern EXP fixp();
extern EXP unboundp();
extern EXP value();
extern EXP explength();

extern int c_init();
extern void dereference();
extern EXP reference();
extern void purge();
extern void erase();
extern EXP c_replace();
extern void c_release();
extern void c_link();
extern EXP c_alink();
extern EXP c_dlink();
extern void c_unlink();
extern void c_decr();
extern void c_prints();
extern EXP reads();
/* extern EXP car();         */
/* extern EXP cdr();       */
extern PTRFCELLPTR cfr();
extern EXP cons(EXP, EXP);
extern EXP append(EXP, EXP);
extern EXP get_cell();
extern EXP lookup();
extern EXP c_oblist();

extern char *csr();
extern char *pname();
extern EXP nameof();
extern EXP c_tostr();
extern void rplci();
extern int ccr(EXP);
extern int c_lenstr();
extern int cir(EXP);
extern float cflor(EXP);
extern FILE *cor(EXP);
extern void *cvoidr(EXP);
extern EXP newicell(int);
extern EXP newflocell(float);
extern EXP newfcell();
extern EXP newffcell();
extern EXP newscell();
extern EXP newbscell();
extern EXP newocell();
extern EXP newvoidcell(void *);
extern EXP newbigstring(char *);
extern EXP eval();
extern void set(EXP, EXP);
extern EXP plus();
extern EXP difference();
extern EXP remainder();
extern EXP times();
extern EXP quotient();
extern EXP blog();
extern EXP blog10();
extern EXP bexp();

void fprints(FILE *, EXP, int);
#define PRIN1 (1)
#define PRINC ((int)0)
#define PRINSYMBOL (2)
/*
 * Macros needed to translate between Lisp Booleans and C.
 * C expects false == 0.
 */
#define lif(x) if(((x)!=NIL?1:0))  /* convert from Lisp to C if statement */
#define lwhile(x) while(((x)!=NIL?1:0))  /* Lisp to C while statement */
#define lor(a,b) ( ((a)!=NIL) ? T : ( ((b)!=NIL) ? T : NIL) )  /* OR */
#define land(a,b) ( ((a)==NIL) ? NIL : ( ((b)==NIL) ? NIL : T) )   /* AND */

/*
 * Macros introduced after profiling. These speed up the interpreter 
 * by 50% overall. Most frequently used listed first.
 */
#define null(x) ((x)==NIL?T:NIL)
#define lnot(x) ((x)==NIL?T:NIL)
#define consp(x) ((x)==NIL?NIL:((x)->ztype == PAIR?T:NIL))
#define listp(x) ((x)==NIL?NIL:((x)->ztype == PAIR?T:NIL))
#define c_unlink(x) if(((x) != NIL? ((x)->zcount -= 1) <= 0 : 0)) c_unlinkaux(x)
#define trace_exp(x) {if(trace_on) trace_exp_aux(x);}
#define trace(x) {if(trace_on) traceaux(x);}
#define dump if(trace_on)
#ifndef SLOW
#define car(x) ((x)->ztype == PAIR?(x)->reg.zpair.zcar:\
c_error_func("not PAIR for CAR",(x)))
#define cdr(x) ((x)->ztype == PAIR?(x)->reg.zpair.zcdr:\
c_error_func("not PAIR for CDR",(x)))
#define atom(x) ((x)->ztype != PAIR?T:NIL)
#define subrp(x) ((x)->ztype == SUBRP?T:NIL)
#define fsubrp(x) ((x)->ztype == FSUBRP?T:NIL)
#define numberp(x) ((((x)->ztype == INTEGER)||((x)->ztype == FLOAT))?T:NIL)
#define floatp(x) ((x)->ztype == FLOAT?T:NIL)
#define bigstringp(x) ((x)->ztype == BIGSTRING?T:NIL)
#define stringp(x) ((x)->ztype == STRING?T:NIL)
#define filep(x) ((x)->ztype == FILEPTR?T:NIL)
#define constantp(x) ((x)->ztype == CONSTANT?T:NIL)
#define idp(x) lor(((x)->ztype == IDENTIFYER?T:NIL),constantp((x)))


#endif
/*
 * Macro for declaring functions which are FSUBR or SUBR
 * called by apply(). They all have the same calling convention,
 * the macro allows this to be changed cleanly.
 */
#define LISPFUNC(name) EXP name(EXP args)

/*
 * Macro to test if Bill Birch's non-standard extensions are to be used.
 */
#define non_standard if(flag_non_standard)

