#include <stdio.h>
#include <stdlib.h>
#include "cells.h"
#include <time.h>

int flag_non_standard = 0;
int trace_on = 0;
int eval_depth = 0;
extern long cellcount;
extern long watermark;
extern long totalcells;
extern char *filearg();
extern EXP rdsym(EXP);
 
char version[] = "2.67";
char thedate[] = "27 Feb 1993";
EXP e_null(EXP);
EXP about(EXP);

EXP eval(EXP);
EXP apply(EXP, EXP);
EXP ref_evlis(EXP);
EXP evcond(EXP);
EXP evwhile(EXP);

EXP ap_lambda(EXP, EXP, EXP);
EXP eval_list(EXP, EXP);
EXP savelis(EXP);
void setlis(EXP, EXP);
void restorlis(EXP);

EXP evprogn(EXP);

/*
 * Constant pointers
 */
EXP lambda = NIL;
EXP macro = NIL;
EXP lambdaq = NIL;
EXP rest = NIL;
EXP optional = NIL;


void traceaux(char *str)
{
	printf(str);
	fflush(stdout);
}
void trace_exp_aux(EXP sexp)
{
		c_prints(sexp);
}
EXP trace_toggle(EXP flag)
{
	if( cir(car(flag)) == 0)
		trace_on = 0;
	else if( cir(car(flag)) == 1)
		trace_on = 1;
	return(T);
}
EXP bextensions(EXP flag)
{
	lif( car(flag) )
		flag_non_standard = 1;
	else
		flag_non_standard = 0;
        	
	return(T);
}
EXP u_error(EXP x)
{
	c_error("user:",x);
	return(T);
}
void printn_spaces(int n)
{
	for(; n>0; n--)
		printf(" ");
}
/****************************************************************
 *
 */

LISPFUNC(eroom)
{
	args = args;
    return(newicell(totalcells));
}
LISPFUNC(about)
{
	args = args;
	fprintf(stderr,"         RefLisp, Version %s             \n",version);
	fprintf(stderr,"  Copyright (C) Peter William Birch    \n");
	fprintf(stderr,"         %s             \n\n",thedate);

	fprintf(stderr,"    An experiment in garbage collection       \n");
	fprintf(stderr,"           by reference-counting.          \n\n");

	fprintf(stderr,"      Telephone +44 442 230 654\n");
	fprintf(stderr," Gadebridge, Hemel Hempstead, HP1 3LQ, U.K.          \n\n");

	fprintf(stderr,"Cell Pool has %ld cells x %d bytes/cell = %ld bytes\n", 
		(long)totalcells,
		(int)sizeof(CELL),
		(long)sizeof(CELL)*(long)totalcells);
	fprintf(stderr,"there are %ld free cells , lowest watermark= %ld \n",
		cellcount, watermark); 
	{
		time_t now = time((time_t *)NULL) ;
		printf("Universal time now is: %ld\n", now);
	}
	return( T );
}
/****************************************************************
 *
 */
EXP e_null(EXP x)
{
	lif( null(car(x)) )
		return( T );
	else
		return( NIL );
}
/****************************************************************************
 *
 *
 *
 */
EXP ref_evlis(EXP list)
{
EXP result =NIL;
EXP start =NIL;
EXP previous =NIL;

	lwhile( lnot(null(list))) {
		result = reference(cons(eval(car(list)),NIL));
		lif(previous)
			previous->reg.zpair.zcdr = result;
		else
			start = result;
		list = cdr(list);
		previous = result;
	}
	return(start);
}
/****************************************************************************
 *
 *
 *
 */
EXP eval(EXP form)
{
EXP retval;

	dump {
		eval_depth++;
		printf("%4d eval: ", eval_depth);
		printn_spaces(eval_depth);
		c_prints(form);
		printf("\n");
	}
   lif( null(form) ) {
      retval = NIL;
	}
   else lif( numberp( form) )
	  retval = form ;
   else lif( stringp( form) )
      retval = form ;
   else lif( bigstringp( form) )
	  retval = form;
   else lif( subrp( form) )
	  retval = form;
   else lif( fsubrp( form) )
	  retval = form ;
   else lif( filep(form) )
		retval = form;
   else lif( atom(form) ) {
	  if( value(form) != UNBOUND ) {
		 retval = value(form);
      }
      else {
         c_error("eval: unbound variable",form);
		 retval = NIL;
      }
   }
   /* Now lists */
   else {
	retval = eval_list( car(form), cdr(form) );
   }
	dump {
		printf("%4d eval= ", eval_depth);
		printn_spaces(eval_depth);
		c_prints(retval);
		eval_depth--;
		printf("\n");
	}
    return(retval);
}
/****************************************************************************
 *
 *
 *
 */
EXP eval_list( EXP func, EXP args )
{
	lif( atom(func) ) {
			lif( subrp(func)  ) {
         		EXP actuals, result;

         		actuals = ref_evlis( args );
				result = reference(apply( func, actuals ));
         		purge( actuals );
		 		dereference(result); 
         		return(result);
      		}	 
      		else {
				lif( fsubrp(func) ) {
					return(apply( func, args ));
      			}
				else {
				EXP evaled = reference(eval(reference(func)));
				EXP result = reference(eval_list(evaled, args));

				purge(evaled);
            	dereference(func); dereference(result);
				return(result);
				}
        	}
   	}
   	else {  /* if func is a list */
			lif( eq( car(func), lambdaq ) ) {
			return( apply(func, args ) );
      		}
			else lif( eq( car(func), macro ) ) {
				EXP result;
				EXP appresult = reference(apply(func, args ));
				result = reference(eval(appresult));
				purge(appresult);
				dereference(result);
				return( result );
      		}
      		else {
			EXP actuals, result;

			actuals = ref_evlis( args );

			result = reference(apply(func, actuals ));
			purge(actuals);
			dereference(result);
			return(result);
      		}
   	}
}
/****************************************************************************
 *
 *
 *
 */
EXP apply(EXP func, EXP args)
{
	dump {
		printf("%4d apply: ", eval_depth);
		printn_spaces(eval_depth);
		c_prints(func);
		c_prints(args);
		printf("\n");
	}
	lif( null(func) ) {
         return(NIL);
	}
	non_standard {
		/* first make sure that the list is not the name of a symbol */
		EXP form = cons(func, args);
		EXP symbol = rdsym(form);
		lif( symbol ) {
			c_release(form);
			return(eval(symbol)); /* get the symbol value */
		}
		c_release(form);
	}
 	lif( atom(func) ) {
			lif( lor( subrp( func ) , fsubrp( func )) ) {
				register EXP retval;
				register PTRFCELLPTR  fn;
		
				fn =  cfr(func);
				retval = (*fn)(args);
				return(retval);
      		}
			else {
				EXP evaled = reference(eval(reference(func)));
				EXP result = reference(apply(evaled, args));

				purge(evaled);
            	dereference(func); dereference(result);
				return(result);
		}
   	}
   	/* now when func is a list */ 
   	else {
		lif( lor(lor( eq( car(func) , lambda) ,
			 eq( car(func) , lambdaq) ) ,
			eq( car(func) , macro))) {
  	    		return( ap_lambda( cdr(cdr(func)),
  		       		car(cdr( func)),
  		       		args ));
	   	}
		else {
			EXP evaled = reference(eval(reference(func)));
			EXP result = reference(apply(evaled, args));

			purge(evaled);
            dereference(func); dereference(result);
			return(result);

		}
	}
}

/****************************************************************************
 *
 *
 *
 */
EXP evwhile( EXP form )
{
EXP condition, result=NIL;

   lif( null(form)  ) {
      serr("null while");
      return(NIL);
   }
   else {
      	condition = reference( eval( car(form)) );
		while( condition != NIL ) {
			purge(result);
    	   	result = reference(evprogn( cdr(form)));
	      	purge(condition);
      		condition = reference( eval( car(form)) );
		}
		purge(condition);
   }
	dereference(result);
   return( result );
}

/****************************************************************************
 *
 *  (do-until (<end-test> results ... <result>) body ...)
 *
 */
EXP evuntil( EXP form )
{
EXP condition, result=NIL;
EXP end_form = NIL;

   lif( null(form)  ) {
      serr("null until");
      return(NIL);
   }
   else {
	end_form = car(form);
	condition = reference( eval( car(end_form)) );
	while( condition == NIL ) {
		purge(result);
    	   	result = reference(evprogn( cdr(form)));
	      	purge(condition);
		condition = reference( eval( car(end_form)) );
		}
	purge(result);
	/* calculate the result */
	result = reference(evprogn( cdr(end_form)));
	purge(condition);
	dereference(result);
	return( result );
   }
   return(NIL);
}

/****************************************************************************
 *
 *
 *
 */
EXP evcond(EXP form)
{
EXP condition, result =NIL;

	lwhile(form) {
		condition = reference(eval(car(car(form))));
		if(condition != NIL) {
			lif(lnot(null(cdr(car(form))))) {
				result = reference(evprogn(cdr(car(form))));
				purge(condition);
				dereference(result);
				return(result);
			}
			else {
				dereference(condition);
				return(condition);
                        }
		}
		else {
			purge(condition);
		}
		form = cdr(form);
	}
	return(NIL);
}
/****************************************************************************
 *
 *
 *
 */
EXP ap_lambda( EXP forms, EXP arglist, EXP actual)
{
EXP old, result;


   old = reference( savelis(arglist));
   setlis(arglist, actual);
   result = reference( evprogn(forms));
   restorlis(old);
   purge(old);
   dereference( result);
   return(result);
}
/****************************************************************************
 *
 *
 *
 */
void setlis(EXP arglist, EXP actual)
{
int optional_on = 0;           /* flag 1 if &optional parameters */

	lwhile(arglist) {
	EXP symbol = NIL;
		int default_on = 0;     /* flag 1 if parameter has a default */

		lif( eq(car(arglist), optional) ) {
			optional_on = 1;
			arglist = cdr(arglist); /* skip the flag */
		}
		lif( eq(car(arglist), rest) ) {
			arglist = cdr(arglist); /* skip the flag */
			set( car(arglist), actual);
			return;
		}
		lif(atom(car(arglist))) {
			symbol = car(arglist);
                }
		else {
                	default_on = 1;
			symbol = car(car(arglist));
		}

		lif(null(actual)) {
			if( optional_on) {
				if(default_on) {
					set( symbol,
						eval(car(cdr(car(arglist)))));
				}
                                else {
					set( symbol, NIL);
				}
				arglist = cdr(arglist);
			}
			else {
				c_error("setlis: missing args in function",arglist);
				return;
			}
		}
		else {
			set( symbol, car(actual));
			arglist = cdr(arglist);
			actual = cdr(actual);
                }
	}
	lif( actual )
		c_error("setlis: too many args in function",actual);
}
/****************************************************************************
 *
 *
 *
 */
EXP savelis(EXP arglist)
{
	lif(null(arglist))
		return(NIL);
	else lif( atom(arglist) ) {
		return( cons(cons( arglist, value( arglist)), NIL));
	}
	else {
	register EXP result = NIL;
        register EXP symbol = NIL;

		lwhile( lnot(null(arglist)) ) {
			lif(atom(car(arglist))) {
				symbol = car(arglist);
			}
			else {
				symbol = car(car(arglist));
                        }
			result = cons( cons( symbol, 
						value( symbol)),result);
			arglist = cdr(arglist);
		}
		return(result);
	}
}

/****************************************************************************
 *
 *
 *
 */
void restorlis(EXP alist)
{

   while( alist != NIL ) {
      set( car(car(alist)), cdr(car(alist)) );
      alist = cdr(alist);
   }
}
/****************************************************************
 *
 */
EXP evprogn(EXP args)
{
EXP start,retval = NIL;

	lif( lnot(consp(args)) )
		return(NIL);
	else {
		start = reference(args);
		do {
			purge(retval);
			retval = reference( eval(car(args)) );
			args = cdr(args);
			
		} lwhile( lnot(null(args)));

		dereference(start);
		dereference(retval);
		return(retval);
	}
}
/*
 * Auxiliary functions
 */
EXP bcar(EXP arg) {
	lif(null(car(arg))) {
		return(NIL); }
	    else { return( car(car(arg)) ); }}

EXP bcdr(EXP arg) {
	lif(null(car(arg)))
		{ return(NIL); }
	    else { return( cdr(car(arg)) ); }}

EXP bcadr(EXP arg)  { return( nth((int) 1, car(arg)) ); }
EXP bcaddr(EXP arg) { return( nth((int) 2, car(arg)) ); }
EXP bnth(EXP arg) { return( nth(cir(car(arg)), car(cdr(arg))) ); }
EXP bcons(EXP arg) { return( cons(car(arg),car(cdr(arg))) ); }
EXP breplace( EXP args)
{
	return(c_replace(car(args), car(cdr(args)) ) );
}
EXP batom(EXP arg)  { return( atom(car(arg)) ); }
EXP bpairp(EXP arg) { return( consp(car(arg)) ); }
EXP blistp(EXP arg)  { return( listp(car(arg)) ); }
EXP bidp(EXP arg) { return( idp(car(arg)) ); }
EXP bstringp(EXP arg) { return( stringp(car(arg)) ); }
EXP bnumberp(EXP arg)  { return( numberp(car(arg)) ); }
EXP bfixp(EXP arg) { return( fixp(car(arg)) ); }
EXP bfloatp(EXP arg)  { return( floatp(car(arg)) ); }
EXP bmember(EXP arg)  { return( member(car(arg),car(cdr(arg))) ); }
EXP bccr(EXP arg)  { return( newicell(ccr(car(arg))) ); }
EXP beq(EXP arg)  { return( eq(car(arg),car(cdr(arg))) ); }
EXP bequal(EXP arg) { return( equal(car(arg),car(cdr(arg))) ); }
EXP beval(EXP arg) { return( eval(car(arg)) ); }
EXP bapply(EXP arg) { return( apply(car(arg),car(cdr(arg))) ); }
EXP bquote(EXP args) { return( car(args) ); }
EXP bsetq(EXP args)
{
EXP result = eval( car(cdr(args)) );

	set( car(args), result );
	return( result ); 
}
EXP bde(EXP args) {
		 set( car(args), cons( lambda, cdr(args) ) ) ;
		 return( car(args) );
      }
EXP bdm(EXP args) {
		 set( car(args), cons( macro, cdr(args) ) ) ;
		 return( car(args) );
      }
EXP bdf(EXP args) {
		 set( car(args), cons( lambdaq, cdr(args) ));
		 return( car(args) );
      }
void InitEval()
{

   lambda = reference(lookup("lambda"));
   macro= reference( lookup("macro"));
   lambdaq = reference( lookup("lambdaq"));
   optional = reference( lookup("&optional"));
   rest = reference( lookup("&rest"));
   set( lookup("ccr"), newfcell(bccr));
   set( lookup("car"), newfcell( bcar ) );
   set( lookup("cdr"), newfcell(bcdr));
   set( lookup("nth"), newfcell(bnth));
   set( lookup("cadr"), newfcell(bcadr));
   set( lookup("caddr"), newfcell(bcaddr));
   set( lookup("cons"), newfcell(bcons));
   set( lookup("move"), newfcell(breplace));
   set( lookup("atom"), newfcell(batom));
   set( lookup("symbolp"), newfcell(bidp));
   set( lookup("member"), newfcell(bmember));
   set( lookup("stringp"), newfcell(bstringp));
   set( lookup("numberp"), newfcell(bnumberp));
   set( lookup("integerp"), newfcell(bfixp));
   set( lookup("floatp"), newfcell(bfloatp));
   set( lookup("consp"), newfcell(bpairp));
   set( lookup("equal"), newfcell(bequal));
   set( lookup("eq"), newfcell(beq));
   set( lookup("eval"), newfcell(beval));
   set( lookup("apply"), newfcell(bapply));
   set( lookup("null"), newfcell( e_null ));

   set( lookup("quote"), newffcell(bquote));
   set( lookup("cond"), newffcell(evcond));
   set( lookup("do-while"), newffcell(evwhile));
   set( lookup("do-until"), newffcell(evuntil));
   set( lookup("setq"), newffcell(bsetq));
   set( lookup("defun"), newffcell(bde));
   set( lookup("defmacro"), newffcell(bdm));
   set( lookup("df"), newffcell(bdf));
   set( lookup("progn"), newffcell(evprogn));

	set( lookup("eroom"), newfcell(eroom));
	set( lookup("room"), newfcell(about));
	set( lookup("dump"), newfcell( trace_toggle ));
	set( lookup("extensions"), newfcell( bextensions ));
	set( lookup("error"), newfcell(u_error) );

}

 

