#ifdef MSDOS

#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "cells.h"

/*
#define clipx(z) (z>ScreenWidth?ScreenWidth:z)
#define clipy(z) (z>ScreenHeight?ScreenHeight:z)
*/
#define clipx(z) (z)
#define clipy(z) (z)
/* Standardised screen size */
#define SCREENSIZEX 6400
#define SCREENSIZEY 4800
/* Horizontal Aspect Ratio */
#define to_real(x) ((x)/aspect_ratio)
#define to_square(x) ((x)*aspect_ratio)

/* Normalised Actual Screen Size */
int	ScreenWidth;
int	ScreenHeight;
int scale_factor = 10;
float aspect_ratio = 1.0;

int MouseScaleX;
int MouseScaleY;


/* Scaling from Virtual to Physical Screen size, factors */
/*
#define SCALEY(x) (ScreenHeight -((int)(((float)(x)*(float)ScreenHeight)/SCREENSIZEY)))
#define SCALEX(x) to_real(((int)(((float)(x)*(float)ScreenWidth)/SCREENSIZEX)))
#define ELACSX(x) ((int)(((float)(to_square(x))*(float)SCREENSIZEX)/ScreenWidth))
#define ELACSY(x) ((int)(((float)(ScreenHeight -(x))*(float)SCREENSIZEY)/ScreenHeight))
#define ABSELACSY(x) ((int)(((float)(x)*(float)SCREENSIZEY)/ScreenHeight))

*/
#define SCALEX(x) (to_real(x/scale_factor))
#define SCALEY(y) (ScreenHeight -(y)/scale_factor)

/* Scaling from Physical to Virtual Screen size, factors */
#define ELACSX(x) (to_square(x)*scale_factor)
#define ELACSY(x) ((ScreenHeight -(x))*scale_factor)
#define ABSELACSY(x) ((x)*scale_factor)

#define inside(x,y) (	((x)<SCREENSIZEX) \
					&& ((x) >= 0) \
					&& ((y)<SCREENSIZEY) \
					&& ((y) >= 0))

#define fpequals(a,b) (a-b<1.0E-10)

void clip(float *x, float *y, float m, float b)
{

	if( *x < 0) {
		*x = 0;
		*y = m*(*x) + b;
	}
	if( *x > SCREENSIZEX) {
		*x = SCREENSIZEX-1;
		*y = m*(*x) + b;
	}
	if( *y > SCREENSIZEY) {
		*y = SCREENSIZEY-1;
		if( m == 0) 
			*x = SCREENSIZEX;
		else
			*x = (*y - b)/m;
	}
	if( *y < 0) {
		*y = 0;
		if( m == 0) 
			*x = SCREENSIZEX;
		else
			*x = (*y - b)/m;
	}
}
void SysMouseOn ()
{
	union REGS inregs, outregs;
	inregs.x.ax = 1;
	int86 (0x33,&inregs,&outregs);

}
void SysMouseOff ()
{
	union REGS inregs, outregs;
	inregs.x.ax = 2;
	int86 (0x33,&inregs,&outregs);

}
static void SysMousePosition (int *fx, int *fy)
{
	union REGS inregs, outregs;

	inregs.x.ax = 3;
	int86 (0x33,&inregs,&outregs);
	*fx = (float) outregs.x.cx;
	*fy = (float) outregs.x.dx;
    *fx = ELACSX( *fx );
	*fy = ELACSY( *fy );

}

int graphics_state = 0;

LISPFUNC(GraphStop)
{
	args = args;
	closegraph();
	graphics_state = 0;
	return(T);
}
void lineaux(int x1, int y1, int x2, int y2)
{
/*	printf("b_pline: x1 %d y1 %d x2 %d y2 %d\n",x1,y1,x2,y2);
*/	line( x1, y1, x2, y2);
}
void b_pline( int x1, int y1, int x2, int y2)
{
#ifdef DEBUG
printf("b_pline: x1 %d y1 %d x2 %d y2 %d\n",x1,y1,x2,y2);
#endif
    SysMouseOff();
    lineaux( clipx(SCALEX(x1)),
		clipy(SCALEY(y1)),
		clipx(SCALEX(x2)),
		clipy(SCALEY(y2)));
    SysMouseOn();

}

void b_fpline( float x1, float y1, float x2, float y2)
{
float m;
float b;			/* y axis intercept */

	if( fpequals(x2, x1) )
		m = 1e-10;
	else
		m = (y2 -y1)/(x2 - x1);	/* slope */ 

	b = y1 - m*x1;
	clip(&x1, &y1, m ,b); 
	clip(&x1, &y1, m ,b);
	clip(&x2, &y2, m ,b);
	clip(&x2, &y2, m ,b);

	if(inside(x1,y1) && inside(x2,y2)) {

#ifdef DEBUG
printf("b_pline: x1 %d y1 %d x2 %d y2 %d\n",x1,y1,x2,y2);
#endif
  
	
	line( SCALEX(x1), SCALEY(y1), SCALEX(x2), SCALEY(y2));

	}
}
LISPFUNC(bpline)
{
EXP x1 = NIL,y1 = NIL,x2 = NIL,y2 = NIL;

	x1 = car(args);
	y1 = car(cdr(args));
	x2 = car(cdr(cdr(args)));
	y2 = car(cdr(cdr(cdr(args))));

	lif( lor(lor(floatp(x1) , floatp(x2)) , lor(floatp(y1) , floatp(y2))) )
		b_fpline( cflor(x1), cflor(y1), cflor(x2), cflor(y2));
	else
		b_pline( cir(x1), cir(y1), cir(x2), cir(y2));
	return(T);
}
LISPFUNC(bmode)
{
	int mode = cir(car(args));
	/* select XOR drawing mode */
	if( mode == 3)
		setwritemode(XOR_PUT);
	else
		setwritemode(COPY_PUT);

	return(NIL);
}

LISPFUNC(btextxy)
{
EXP textarg = car(cdr(cdr(args)));
int x,y, w,h;
int gap = 3;
char buffer[80];

	if(c_tostr(buffer, textarg) == NIL)
		return(NIL);

	x = SCALEX(cir(car(args)));
	y = SCALEY(cir(car(cdr(args))));

	h = textheight(buffer);
	w = textwidth(buffer);

	SysMouseOff();
	outtextxy(x+gap, y+gap, buffer);
	SysMouseOn();
	return(	cons(	newicell((int)ELACSX(w+2*gap)),
					newicell((int)ABSELACSY(h+2*gap))
			)
		);
}
LISPFUNC(brectangle)
{
	args = args;
	return(NIL);
}
LISPFUNC(bclear)
{
	args = args;
	SysMouseOff();
	cleardevice();
	SysMouseOn();
	
	return(NIL);
}
LISPFUNC(bcolour)
{
int old_color = getcolor();

	int colour = cir(car(args));
	setcolor(colour);
	return(newicell(old_color));
}
#define PRT 0
#define AUX 1
#define CON 2
#define MIDI 3

#define B_EVSIZE 4
typedef struct b_message {
	int type;
	int used;
	int data[B_EVSIZE];
} B_MSG;

/*
 * System messages 0 .. 1000
 *
 *		User messages are -ve integers
 */
#define B_NULL_MSG		0
#define B_MOUSE_DOWN 	1
#define B_MOUSE_DOWN_SHIFT 	5
#define B_MOUSE_UP		2
#define B_MOUSE_MOVE 	3
#define B_TIME_OUT	4
/*
 * Other Raw Messages
 */
#define B_KEYB 		100
#define B_MIDI		200
#define B_V24 		300

getmidievent(B_MSG *event)
{
   event = event; return(0);
}
#define LEFTBUTTON 1
#define RIGHTBUTTON 2
#define LSHIFT 1
#define RSHIFT 2

void SysMouseButt(int *buttons)
{
	union REGS inreg, outreg;

	inreg.x.ax = 3;
	int86 (0x33,&inreg,&outreg);
	*buttons = outreg.x.bx;
}
getmousevent(B_MSG *event)
{
static int last_status, last_x, last_y;
int status, x, y, keys;

	SysMousePosition(&x, &y);
    SysMouseButt(&status);

	keys = bioskey(2)&3;

	if( (last_status & LEFTBUTTON)!= (status & LEFTBUTTON) ) {
		if( status & LEFTBUTTON) {
			if( keys & LSHIFT || keys & RSHIFT)
				event->type = B_MOUSE_DOWN_SHIFT;
			else {
				event->type = B_MOUSE_DOWN;
			}
		}
		else 
			event->type = B_MOUSE_UP;
	}
	else if (last_x != x || last_y != y ) {
		event->type = B_MOUSE_MOVE;
	}
	else
		return(0);

	event->used = 3;
	event->data[0]=status;
	event->data[1]=x;
	event->data[2]=y;
	last_status = status;
	last_x = x;
	last_y = y;
	return(1);
}
void getevent(B_MSG *event, int timeout)
{

	event->type = B_NULL_MSG;
	while( event->type == B_NULL_MSG) {
		if(getmousevent(event)) {
			return;
		}
		else if( getmidievent(event) ){
			return;
		}
		else if( bioskey(1) != 0) {
			event->type = B_KEYB;
			event->used = 1;
			event->data[0] = bioskey(0) & 0xFF;
			
		}
		else if(timeout != 0){
			event->type = B_TIME_OUT;
			event->used = 0;
		}

	}
}
LISPFUNC(bgetevent)
{
B_MSG latest;
int c, timeout = 0;
EXP type = NIL, result = NIL;

	lif(lnot(null(args))) {
    	timeout = cir(car(args));
	}
	getevent( &latest, timeout);
	result = NIL;
	for( c = latest.used-1; c >= 0 ; c--) {
		result = cons( newicell(latest.data[c]), result ) ;
	}
	switch ( latest.type ) {

		case  B_MOUSE_DOWN :
				type = lookup("*down*");
				break;
		case  B_TIME_OUT :
				type = lookup("*timeout*");
				break;
		case  B_MOUSE_DOWN_SHIFT :
				type = lookup("*sdown*");
				break;
		case  B_MOUSE_UP :
				type = lookup("*up*");
				break;
		case  B_MOUSE_MOVE :
				type = lookup("*move*");
				break;
		case  B_KEYB 		:
				type = lookup("*keys*");
				break;
		case  B_MIDI		:
				type = lookup("*midi*");
				break;
		case  B_V24 		:
				type = lookup("*rs232*");
				break;
	}
	return(cons( type, result));
}

LISPFUNC(bfillstyle)
{
int pattern = cir(car(args));
int color = cir(car(cdr(args)));

	setfillstyle(pattern, color);
	return( (graphresult()==grError ? NIL : T));
}
LISPFUNC(bfillarea)
{
EXP points = NIL, tmp = NIL;
int number= 0;
/* our polygon array */
#define ARRAYSIZE 20
int poly[ARRAYSIZE];

	points = car(args);
	tmp = points;
	while( number < ARRAYSIZE && tmp != NIL ) {
		poly[number++] = SCALEX(cir(car(car(tmp))));
		poly[number++] = SCALEY(cir(cdr(car(tmp))));
		tmp = cdr(tmp);
	}
	SysMouseOff();
	fillpoly(number/2, poly);
    SysMouseOn();
	return( (graphresult==grOk?T:NIL));
}
LISPFUNC(GraphOpen)
{


	int wdriver = DETECT;
	int wmode = 0;
	int xasp;
	int yasp;

	 if (registerbgidriver(CGA_driver) < 0) {
			serr("registerbgidriver failed");
	 }
	 if (registerbgidriver(EGAVGA_driver) < 0) {
			serr("registerbgidriver failed");
	 }

	lif( args ) {
		wdriver = cir(car(args));
		wmode = cir(car(cdr(args)));
	}
	initgraph(&wdriver, &wmode, "");
	/* read result of initialization */
    { int result = graphresult();
		if ( result != grOk)  { /* an error occurred */
			c_error("graphics initialisation failed",newicell(result));
		}
    }
    SysMouseOn();
/*	setbkcolor (15);
	blockoffset = 512;
	setpalette (15,0);
	SysMouse ();
    */
	{ int xasp, yasp;
		getaspectratio (&xasp, &yasp);
		aspect_ratio = (float) xasp / (float) yasp;
    }
	ScreenWidth = to_square(getmaxx()+1) ;
	ScreenHeight = getmaxy()+1 ;

	if( (ScreenHeight/ScreenWidth ) > (SCREENSIZEX/SCREENSIZEY)) {
    	scale_factor = SCREENSIZEY/ScreenHeight;
	}
	else {
		scale_factor = SCREENSIZEX/ScreenWidth;
	}

	graphics_state = 1;

	return(cons(newicell(SCREENSIZEX),newicell(SCREENSIZEY)));
}
void AbortGraph()
{
	if(graphics_state == 1)
	   closegraph();
}
void InitGraph()
{
	{ /* init mouse */
		/* Assume mouse driver installed for the moment */

	union REGS inregs, outregs;


	inregs.x.ax = 0;
	int86 (0x33,&inregs,&outregs);
	}
	set( lookup("graphopen"), newfcell(GraphOpen));
	set( lookup("graphclose"), newfcell(GraphStop));

	set( lookup("line"), newfcell(bpline));
	set( lookup("mode"), newfcell(bmode));
	set( lookup("textxy"), newfcell(btextxy));
	set( lookup("clear"), newfcell(bclear));
	set( lookup("colour"), newfcell(bcolour));
	set( lookup("fillarea"), newfcell(bfillarea));
	set( lookup("fillstyle"), newfcell(bfillstyle));

	set( lookup("getevent"), newfcell(bgetevent));

	set(lookup("*down*"),	lookup("*down*"));
	set(lookup("*sdown*"),	lookup("*sdown*"));
	set(lookup("*up*"),		lookup("*up*"));
	set(lookup("*move*"),	lookup("*move*"));
	set(lookup("*keys*"),	lookup("*keys*"));
	set(lookup("*midi*"),	lookup("*midi*"));
	set(lookup("*rs232*"),	lookup("*rs232*"));
	set(lookup("*timeout*"),	lookup("*timeout*"));

};
#endif


 
