;;; A SCOOPS example, from the MacScheme distribution

(define-class location
  (classvars (w 'baker)(u 'able))
  (instvars (x 400) 
            (y (active 500 (lambda (x)(display "get method ") x)
                           (lambda (x)(display "set method ") x))))
  (options gettable-variables settable-variables inittable-variables))

(define-class support
  (instvars (price 0) (material 'wood))
  (mixins location)
  (options gettable-variables settable-variables inittable-variables))


;;; The next two examples illustrate two classes with a common
;;; lexical environment. Because chairs mixin furniture and support methods
;;; and a furniture method refers to the bound variable lex, chairs must
;;; be defined in the same environment as furniture. No error will be detected
;;; if this is violated, but in this case, the variable lex refered to in 
;;; chair will be distinct from the variable lex refered to in furniture.

(let ((lex 'baz))
  ;This example shows how to define instance methods.
  (define-class furniture
    (instvars (price 0) (purpose 'sitting))
    (mixins location)
    (options gettable-variables settable-variables inittable-variables))

  (define-method (furniture print-lex) ()
    (display lex)
    (newline))

  (define-method (furniture move) (deltax deltay)
    (set! x (+ x deltax))
    (set! y (+ y deltay)))

  (define-method (furniture set-lex) (x)
    (set! lex x)) 
  
  ;In the following, the important point is that material is not settable
  ;in a chair even though it is settable in support and chair 
  ;inherits from support. The reason is that material in chair shadows
  ;material in support and material is excluded from the settable variables
  ;in the definition of chair.
  
  
  (define-class chair
    (instvars (number-of-legs 4)(material 'metal))
    (mixins furniture support)
    (options gettable-variables 
             (settable-variables number-of-legs)
             inittable-variables)))


;;; sanity checks:

(all-classvars chair)
(all-instvars chair)
(all-methods chair)
(class-compiled? chair)
(define ch1 (make-instance chair 'x 500 'y 500))
(class-compiled? chair)
(class-of-object ch1)
(classvars chair)
(describe chair)
(getcv chair u)
(setcv chair u 'charlie)
(getcv chair u)
(instvars chair)
(methods chair)
(mixins chair)
(name->class 'chair)
(rename-class (chair newchair))
(name->class 'newchair)
(send-if-handles ch1 foo)
(send ch1 set-y 500)
(define-method (location row)
  (z)(+ x y z))
(all-methods chair)
;;; there will be a brief pause while chair is recompiled:
(define ch2 (make-instance chair))
(send ch2 row 5)
(send ch2 set-x 40)
(send ch2 set-y 50)
(send ch2 row 10)



