(declare (special namespacetypes))

(def lookup-constant
   (lambda (id)
      (let ([pair (getl id '(scheme-constant constant-primitive
			       constant-system-function))])
	 (and pair (let ([value (cadr pair)])
		      (cond [(eq value 'unassigned-constant)
			     (raise
				(list 'SE%vsm 0 t
				   '|Unassigned constant:| id))]
			    [t value]))))))

(def declare-constant
   (lambda (c)
      (let ([pair (getl c namespacetypes)])
	 (cond
	    [pair
	       (let ([type (car pair)])
		  (cond
		     ((eq type 'beta-transform)
		      (raise
			 (list 'SE%constant 0 t
			    '|Special forms cannot be declared
			     as constants:| c)))
		     ((eq type 'system-function)
		      (rplaca pair 'constant-system-function))
		     ((eq type 'scheme-primitive)
		      (rplaca pair 'constant-primitive))))]
	    [t (putprop c
		  (let ([cell (baselocation c)])
		     (cond
			[(null cell) 'unassigned-constant]
			[t (prog2 (removefrombase  c) (cdr cell))]))
		  'scheme-constant)]))))

(def undeclare-constant
   (lambda (c)
      (let ([pair (getl c namespacetypes)])
	 (cond
	    [pair
	       (let ([type (car pair)])
		  (cond
		     ((eq type 'constant-system-function)
		      (rplaca pair 'system-function))
		     ((eq type 'constant-primitive)
		      (rplaca pair 'scheme-primitive))
		     ((and (eq type 'scheme-constant)
			   (eq (cadr pair) 'unassigned-constant))
		      (remprop c 'scheme-constant))
		     (t (extendbase c (cadr pair))
			(remprop c 'scheme-constant))))]))))

(mapc (function declare-constant)
      '(save-defining-form load standard-input
	  standard-output scheme-directory))
