(def if
   (macro (l)
	  (cond ((eq (length l) 3) `(cond (,(cadr l) ,(caddr l))))
		((eq (length l) 4) `(cond (,(cadr l) ,(caddr l))
					  (t ,(cadddr l)))))))

(def last
   (lambda (l)
      (cond
	 [(dtpr l) (if (atom (cdr l)) l (last (cdr l)))])))
	 

(defmacro myerrset (x)
   `(car (errset ,x nil)))

(setq ptport nil)

(def transcript-on
   (lambda (file)
      (progn (if ptport (close ptport))
	     (or (setq ptport (outfile file))
		 (raise (list 'SE%print 0 t 'transcript-on:
		    '|Sorry, no ports available|))) ; implicit (reset)
	     (setq old-prompt (lookupinbase 'scheme-prompt))
	     (rplacd (baselocation 'scheme-prompt) "::> ")
	     (cons '&port 
		(cons ptport (cddr (lookup-constant 'standard-output)))))))

(def transcript-off
   (lambda ()
      (cond (ptport (close ptport)
	       (rplacd (baselocation 'scheme-prompt) old-prompt)
	       (setq ptport nil))
	    (t (raise (list 'SE%print 0 t 'transcript-off:
			 '|Transcript mode is not on|))))))

(def open
   (lambda (file mode)
      (cond ((eq mode 'read) (let ((p (myerrset (infile file))))
				  (cond ((null p) nil)
					(t `(&port ,p)))))
	    (t (let ((p (cond ((eq mode 'write) (myerrset (outfile file)))
			      ((eq mode 'append)
			        (myerrset (outfile file "a")))
			      (t (raise (list 'SE%print 0 t 'open:
					   '|bad mode:| mode))))))
		    (cond ((null p) nil)
			  (t `(&port ,p 120 . 1))))))))

(def port?
   (lambda (x)
      (eq (car x) '&port)))

(def lport
   (lambda (port)
      (cond ((and (dtpr port) (eq (car port) '&port)) (cadr port))
	    (t (raise
		  (list 'SE%io 0 t 'input/output: '|Bad port|))))))

(def schclose
   (lambda (port)
      (cond ((or (eq port (global-binding 'standard-input))
		 (eq port (global-binding 'standard-output))) port)
	 (t (close (lport port))(rplaca port '&closed-port)))))

(def eof
   (lambda () '(end-of-file)))

(def standard-input
   (lambda () schpiport))

(setq schpiport `(&port ,piport))

(def standard-output
   (lambda () (lookup-constant 'standard-output)))

(setq schpoport `(&port ,poport 74 . 1))

(def output-port
  (lambda ()
    (let ([pr (baselocation 'output-port)])
      (cond
	[(eq (cdr pr) 'unassigned) (lookup-constant 'standard-output)]
	[(setq =temp= (assq pr **fnv**)) (cdr =temp=)]
	[t (cdr pr)]))))

(def modeprint
   (lambda (x port mode)
      (let ((val (errset
		    (progn 
		       (setq schport (lport port))
		       (setq colpair (cddr port))
		       (setq linelen (car colpair))
		       (setq pmode mode)
		       (setq linecount 
			  (cond ((eq schport poport) 10)
				(t -1)))
		       (catch (objprint x) nomore)))))
	 (cond
	    ((null val) (schclose port) (reset))
	    (t (car val))))))
			       
(def print-sys-type
   (lambda (type)
	  (colprint (cdr (assq (car type)
			        (lookupinbase 'unprintables)))
	      'print)))

(def sys-type?
   (lambda (typed-object)
      (and (or (eq pmode 'display) (eq pmode 'print))
	   (assq (car typed-object) 
		 (lookupinbase 'unprintables)))))

(def colprint
   (lambda (atm mode)
      (prog (len)
	    (cond ((plusp linelen)
		   (setq len (cond ((bigp atm) (flatsize atm))
				   ((portp atm) 7) ; a guess
				   (t (pntlen atm))))
		   (cond ((and (or (eq mode 'display)
				   (eq mode 'display&)) 
			       (stringp atm))
			  (setq len (+ len 2))))
		   (cond ((> (cdr (rplacd colpair (+ (cdr colpair) len)))
			     linelen)
			  (terpri schport)
			  (rplacd colpair len)
			  (cond ((zerop (setq linecount (1- linecount)))
				 (princ "MORE? ")
				 (cond ((memq (prog2 (drain piport) 
						     (readc) 
						     (drain piport))
					      '(n q N Q))
					(throw nil nomore))
				       (t (setq linecount 10)
					  (terpri)))))))))
	    (cond ((or (eq mode 'display)
		       (eq mode 'display&)) (print atm schport))
		  (t (princ atm schport))))))

(def objprint
   (lambda (x)
      (cond ((atom x) (colprint x pmode))
	    ((sys-type? x) (print-sys-type x))
	    (t (colprint "(" 'print)
	       (objprint (car x))
	       (objprint-cdr (cdr x))))))

(def objprint-cdr
   (lambda (x)
      (cond ((null x) (colprint ")" 'print))
	    ((atom x) 
	     (colprint " . " 'print)
	     (colprint x pmode)
	     (colprint ")" 'print))
	    ((sys-type? x)
	     (colprint " . " 'print)
	     (print-sys-type x)
	     (colprint ")" 'print))
	    (t (colprint " " 'print)
	       (objprint (car x))
	       (objprint-cdr (cdr x))))))

(def schread
   (lambda ()
      (let ((port (lookupinbase 'input-port)))
	   (let ((val (safe-read 'read port)))
		(cond ((and (eq port keyboard)
			    ptport)
		       (print val ptport)
		       (terpri ptport)))
		val))))

(def schread/port
   (lambda (port)
      (let ((val (safe-read 'read port)))
	 (cond ((and (eq port keyboard)
		     ptport)
		(print val ptport)
		(terpri ptport)))
	 val)))

(def read-char
   (lambda ()
      (safe-read 'readc (lookupinbase 'input-port))))
	        
(def read-atom 
   (lambda ()
      (safe-read 'ratom (lookupinbase 'input-port))))

(def read-char/port
   (lambda (port)
      (safe-read 'readc port)))
	        
(def read-atom/port
   (lambda (port)
      (safe-read 'ratom port)))

(def prompt-read
   (lambda (pr)
      (standardprint pr) (standardprint " ")
      (standardread)))

(def display 
   (lambda (x)
      (let ((port (lookupinbase 'output-port)))
	   (modeprint x port 'display))))

(def display&
   (lambda (x)
      (let ((port (lookupinbase 'output-port)))
	   (modeprint x port 'display&))))

(def schprint&
   (lambda (x)
      (let ((port (lookupinbase 'output-port)))
	   (modeprint x port 'print&))))

(def schprint
   (lambda (x)
      (let ((port (lookupinbase 'output-port)))
	   (modeprint x port 'print))))

(def new-line
   (lambda ()
      (let ((port  (lookupinbase 'output-port)))
	   (progn (terpri (lport port))
		  (rplacd (cddr port) 1)
		  nil))))

(setq oldprompt ">>> ")

(def pretty
   (lambda (l)
      (cond ((atom l) (raise (list 'SE%pretty 0 t 'pretty:
				'|argument not a list:| l))))
      (prog (x gtype gb atm outport errlst oldpoport)
	    (setq oldpoport poport)
	    (setq poport (lport (lookupinbase 'output-port)))
	    loop
	    (setq atm (car l))
	    (setq x (assq atm (lookupinbase 'defined-forms)))
	    ($prpr (cond (x (cdr x))
			 ((setq gtype (global-namespacetype atm))
			  (setq gb (global-binding atm))
			  (cond ((eq gtype 'system-function)
				 `(function-alias ',atm ',gb))
				((proc? gb)
				 (setq errlst (cons atm errlst))
				 `(quote (,atm not-at-all-pretty)))
				(t `(set! ,atm ',gb))))
			 ((setq gb (lookupinbase atm))
			  `(set! ,atm ',gb))
			 (t (setq errlst (cons atm errlst))
			    `(quote (,atm not-globally-bound)))))
	    (setq l (cdr l))
	    (terpri)
	    (terpri)
	    (cond (l (go loop)))
	    (setq poport oldpoport)
	    (return t))))

(def ldisplay
   (lambda (x)
      (modeprint x (lookup-constant 'standard-output) 'display)))

(def current-column
   (lambda ()
      (let ((p (lookupinbase 'output-port)))
	   (progn (lport p)
		  (cdddr p)))))

(def line-length
   (lambda (p)
      (progn (lport p)
	     (caddr p))))

(def set-line-length!
   (lambda (p len)
      (progn (lport p)
	     (rplaca (cddr p) len)
	     len)))


(def standardread
   (lambda ()
      (let ((port (lookup-constant 'standard-input)))
	   (let ((val (read (lport port) (eof))))
		(cond (ptport (print val ptport) (terpri ptport)))
		val))))

(def standardprint
   (lambda (x)
      (let ((port (lookup-constant 'standard-output)))
	   (modeprint x port 'print))))

(def safe-read
   (lambda (readfn port)
      (let ((val (errset (apply readfn (list (lport port) (eof))))))
	 (rplacd colpair 0)
	 (cond
	    ((null val) (errset (readc (lport port) (eof)) t) 
	     (if (not (eq keyboard port))
		 (progn (schclose port) (reset))))
	    (t (car val))))))


; Pretty-printer improvements by Jeff Brennan:

; Here's the printmacro for def.  The original $prdf had some special code
; for lambda and nlambda.

(declare (special $outport$ x)
;    for-each
;    expand-fe
)

(eval-when (compile eval)
   (def expand-fe
     (lambda 
      (form)
      (prog (vars body)
            (return
             (cons (cond ((memq (cadr form)
                                (quote
                                 (map mapc
                                      mapcan
                                      mapcar
                                      mapcon
                                      mapconc
                                      maplist)))
                          (setq form (cdr form))
                          (car form))
                         (t 'mapc))
                   (progn (setq vars (cadr form))
                          (cond ((atom vars) (setq vars (list vars))))
                          (cons (cons 'function
                                      (ncons
                                       (cons 'lambda
                                             (cons vars
                                                   (setq body
                                                         (Cnth (cdddr
                                                                form)
                                                               (length
                                                                vars)))))))
                                (ldiff (cddr form) body)))))))))

(def for-each (macro (l) (expand-fe l)))

(def printdef
  (lambda (l lmar rmar)
    (cond ((and (zerop lmar)		; only if we're really printing a defn
                (zerop rmar)
                (cadr l)
                (atom (cadr l))
                (caddr l)
                (null (cdddr l))
                (eq (caaddr l) 'lambda)
                (null (cdr (last (caddr l)))))
           (princ '|(| $outport$)
           (princ (car l) $outport$)
           (princ '| | $outport$)
           (princ (cadr l) $outport$)
           (terpri $outport$)
           (princ '|  (| $outport$)
           (princ (caaddr l) $outport$)
           (princ '| | $outport$)
           (princ (cadaddr l) $outport$)
           (terpri $outport$)
           (for-each x (cddaddr l) ($prdf x 4 0))
           (princ '|))| $outport$)
           t))))

(putprop 'def 'printdef 'printmacro)

(def printmkmac
  (lambda (l lmar rmar)
    (cond ((and (zerop lmar)
	        (zerop rmar)
		(cadr l))
           (princ '|(| $outport$)
           (princ (car l) $outport$)
           (princ '| | $outport$)
           (princ (cadr l) $outport$)
           (terpri $outport$)
	   ($prdf (caddr l) 7 0)
	   (princ '|)| $outport$)
	   t))))


;;
;;	simpler version which
;;	should look nice for lambda's also.(inside mapcar's) -dhl
;;

(defun print-lambda (l lmar rmar)
  (prog (col)
	(cond ((cdr (last l)) (return nil)))
	(setq col (add1 lmar))
	(princ '|(| $outport$)
	(princ (car l) $outport$)
       	(princ '| | $outport$)
        (print (cadr l) $outport$)
	(mapc '(lambda (x)
		 ($prdf x (+ lmar 2) rmar))
			(cddr l))
        (princ '|)| $outport$)
;	(terpr $outport$)
;	(tab lmar $outport$)
	(return t)))

(putprop 'macro 'printdef 'printmacro)
(putprop 'define 'printdef 'printmacro)
(putprop 'mkmac 'printmkmac 'printmacro)
(putprop 'lambda 'print-lambda 'printmacro)
(putprop 'mulambda 'print-lambda 'printmacro)
(putprop 'fluid-lambda 'print-lambda 'printmacro)
